SuperStrict

' Example 6: File Reading
' Demonstrates: SpeakFile(), GetFileEncoding()

Framework BRL.StandardIO
Import BRL.FileSystem

Import "-L."
Import "-lBlitzSpeech"
Include "BlitzSpeechH.bmx"

Print "BlitzSpeech - File Reading Example"
Print ""

If InitSpeech() = SP_INIT_SUCCESS Then
    
    ' Create a test text file
    Print "Creating test file: speech_test.txt"
    Local file:TStream = WriteStream("speech_test.txt")
    If file Then
        file.WriteLine("This is line one of the test file.")
        file.WriteLine("This is line two.")
        file.WriteLine("BlitzSpeech can read and speak text files automatically.")
		file.WriteLine("How posh is that?")
        file.Close()
        Print "Test file created!"
    Else
        Print "ERROR: Could not create test file!"
        CleanupSpeech()
        End
    End If
    Print ""
    
    ' Detect file encoding
    Print "Detecting file encoding..."
    Local encoding:Int = GetFileEncoding("speech_test.txt")
    Local encodingName:String
    Select encoding
        Case SP_ENC_ANSI
            encodingName = "ANSI"
        Case SP_ENC_UTF16_LE
            encodingName = "UTF-16 LE"
        Case SP_ENC_UTF16_BE
            encodingName = "UTF-16 BE"
        Case SP_ENC_UTF8
            encodingName = "UTF-8"
        Default
            encodingName = "Unknown"
    End Select
    Print "  Detected: " + encodingName
    Print ""
    
    ' Read and speak the file
    Print "Reading and speaking file..."
    Local result:Int = SpeakFile("speech_test.txt")
    If result = SP_FILE_SUCCESS Then
        Print "File spoken successfully!"
    Else
        Print "ERROR: Failed to speak file (code: " + result + ")"
    End If
    Print ""
    
    ' Try to speak a non-existent file
    Print "Testing error handling with non-existent file..."
    result = SpeakFile("nonexistent.txt")
    If result = SP_FILE_ERR_CANT_OPEN Then
        Print "  Correctly handled missing file error"
    End If
    Print ""
    
    CleanupSpeech()
    Print "Done!"
Else
    Print "Failed to initialize speech!"
EndIf